﻿using System;

namespace ArraySize
{
    class Program
    {
        static void Main(string[] args)
        {
            CalendarEvent[] events =
            {
                new CalendarEvent
                {
                    Title = "Swingowa potańcówka na nabrzeżu",
                    StartTime = new DateTimeOffset (2009, 7, 11, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Sobotnia noc swingowa",
                    StartTime = new DateTimeOffset (2009, 7, 11, 19, 30, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(6.5)
                },
                new CalendarEvent
                {
                    Title = "Formula 1 - Grand Prix Niemiec",
                    StartTime = new DateTimeOffset (2009, 7, 12, 12, 10, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(3)
                },
                new CalendarEvent
                {
                    Title = "Piknik swingowy",
                    StartTime = new DateTimeOffset (2009, 7, 12, 15, 00, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(4)
                },
                new CalendarEvent
                {
                    Title = "Łamańce swingowe w klubie Setka",
                    StartTime = new DateTimeOffset (2009, 7, 13, 19, 45, 00, TimeSpan.Zero),
                    Duration = TimeSpan.FromHours(5)
                }
            };

            foreach (CalendarEvent[] day in GetEventsByDay(events, new DateTime(2009, 7, 11), 5))
            {
                Console.WriteLine("-----");
                PrintEvents(day);
            }

            // Listing 7-21. Wielowymiarowa tablica prostokątna.
            int[,] walls = new int[,]
            {
                { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
                { 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1 },
                { 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1 },
                { 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1 },
                { 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1 },
                { 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0 },
                { 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1 },
                { 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1 },
                { 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1 },
                { 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1 },
                { 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1 },
                { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }
            };


            Console.WriteLine(CanCharacterMoveDown(0, 1, walls));
            Console.WriteLine(CanCharacterMoveDown(1, 1, walls));
            Console.WriteLine(CanCharacterMoveDown(3, 1, walls));
            Console.WriteLine(CanCharacterMoveDown(9, 1, walls));
            Console.WriteLine(CanCharacterMoveDown(10, 1, walls));
            Console.WriteLine(CanCharacterMoveDown(10, 4, walls));
            Console.WriteLine(CanCharacterMoveDown(10, 5, walls));
        }

        // Listing 7-20. Tworzenie tablicy tablic.
        static CalendarEvent[][] GetEventsByDay(CalendarEvent[] allEvents,
                                                DateTime firstDay,
                                                int numberOfDays)
        {
            CalendarEvent[][] eventsByDay = new CalendarEvent[numberOfDays][];

            for (int day = 0; day < numberOfDays; ++day)
            {
                DateTime dateOfInterest = (firstDay + TimeSpan.FromDays(day)).Date;
                CalendarEvent[] itemsOnDateOfInterest = Array.FindAll(allEvents,
                e => e.StartTime.Date == dateOfInterest);
                eventsByDay[day] = itemsOnDateOfInterest;
            }

            return eventsByDay;
        }

        static void PrintEvents(CalendarEvent[] events)
        {
            foreach (CalendarEvent item in events)
            {
                Console.WriteLine(item.Title + ": " + item.StartTime);
            }
        }

        // Listing 7-22. Odwołania do elementów tablicy prostokątnej.
        static bool CanCharacterMoveDown(int x, int y, int[,] walls)
        {
            int newY = y + 1;

            // Nie można wyjść poza dolną krawędź mapy.
            if (newY == walls.GetLength(0)) { return false; }

            // Można się przesunąć, wyłącznie jeśli po drodze nie ma ściany.
            return walls[newY, x] == 0;
        }
    }
}
